/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.codec.CodecFix;
import me.jddev0.ep.codec.PacketCodecFix;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import org.slf4j.Logger;

public class FluidStack {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<FluidStack> CODEC_MILLIBUCKETS = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(fluidStack -> class_7923.field_41173.method_10221((Object)fluidStack.fluidVariant.getFluid())), (App)CodecFix.NON_NEGATIVE_LONG.fieldOf("amount").forGetter(fluidStack -> FluidUtils.convertDropletsToMilliBuckets(fluidStack.dropletsAmount)), (App)CodecFix.NON_NEGATIVE_LONG.optionalFieldOf("leftoverDropletsAmount", (Object)0L).forGetter(fluidStack -> {
        long milliBucketsAmount = FluidUtils.convertDropletsToMilliBuckets(fluidStack.dropletsAmount);
        return fluidStack.dropletsAmount - FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount);
    }), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(fluidStack -> fluidStack.fluidVariant.getComponents())).apply((Applicative)instance, (id, milliBucketsAmount, leftoverDropletsAmount, fluidComponents) -> {
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(id);
        long dropletsAmount = FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount) + leftoverDropletsAmount;
        return new FluidStack(fluid, (class_9326)fluidComponents, dropletsAmount);
    }));
    public static final class_9139<class_9129, FluidStack> PACKET_CODEC = class_9139.method_56435((class_9139)FluidVariant.PACKET_CODEC, FluidStack::getFluidVariant, PacketCodecFix.LONG, FluidStack::getDropletsAmount, FluidStack::new);
    private FluidVariant fluidVariant;
    private long dropletsAmount;

    public static FluidStack fromNbt(class_2487 nbtCompound, class_7225.class_7874 registries) {
        if (nbtCompound.method_33133()) {
            return new FluidStack(class_3612.field_15906, class_9326.field_49588, 0L);
        }
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(class_2960.method_60654((String)nbtCompound.method_10558("id")));
        long milliBucketsAmount = nbtCompound.method_10537("amount");
        long dropletsLeftOverAmount = nbtCompound.method_10545("leftoverDropletsAmount") ? nbtCompound.method_10537("leftoverDropletsAmount") : 0L;
        long dropletsAmount = FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount) + dropletsLeftOverAmount;
        class_9326 fluidComponents = nbtCompound.method_10545("components") ? class_9326.field_49589.parse((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)nbtCompound.method_10580("components")).resultOrPartial(error -> LOGGER.error("Tried to load invalid components: '{}'", error)).orElse(class_9326.field_49588) : class_9326.field_49588;
        return new FluidStack(fluid, fluidComponents, dropletsAmount);
    }

    public FluidStack(class_3611 fluid, long dropletsAmount) {
        this(fluid, class_9326.field_49588, dropletsAmount);
    }

    public FluidStack(class_3611 fluid, class_9326 fluidComponents, long dropletsAmount) {
        this(FluidVariant.of((class_3611)fluid, (class_9326)fluidComponents), dropletsAmount);
    }

    public FluidStack(FluidVariant fluidVariant, long dropletsAmount) {
        this.fluidVariant = fluidVariant;
        this.dropletsAmount = dropletsAmount;
    }

    public FluidVariant getFluidVariant() {
        return this.fluidVariant;
    }

    public void setFluidVariant(FluidVariant fluidVariant) {
        this.fluidVariant = fluidVariant;
    }

    public long getDropletsAmount() {
        return this.dropletsAmount;
    }

    public void setDropletsAmount(long dropletsAmount) {
        this.dropletsAmount = dropletsAmount;
    }

    public long getMilliBucketsAmount() {
        return FluidUtils.convertDropletsToMilliBuckets(this.dropletsAmount);
    }

    public boolean isEmpty() {
        return this.fluidVariant.isBlank();
    }

    public class_3611 getFluid() {
        return this.fluidVariant.getFluid();
    }

    public String getTranslationKey() {
        return this.fluidVariant.getFluid().method_15785().method_15759().method_26204().method_9539();
    }

    public class_2487 toNBT(class_2487 nbtCompound, class_7225.class_7874 registries) {
        if (this.fluidVariant.isBlank()) {
            return nbtCompound;
        }
        nbtCompound.method_10582("id", class_7923.field_41173.method_10221((Object)this.fluidVariant.getFluid()).toString());
        long milliBucketsAmount = FluidUtils.convertDropletsToMilliBuckets(this.dropletsAmount);
        long dropletsLeftOverAmount = this.dropletsAmount - FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount);
        nbtCompound.method_10544("amount", milliBucketsAmount);
        if (dropletsLeftOverAmount > 0L) {
            nbtCompound.method_10544("leftoverDropletsAmount", dropletsLeftOverAmount);
        }
        if (this.fluidVariant.getComponents() != null) {
            nbtCompound.method_10566("components", (class_2520)class_9326.field_49589.encode((Object)this.fluidVariant.getComponents(), (DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)new class_2487()).getOrThrow());
        }
        return nbtCompound;
    }
}

